//==============================================================================\\
//	Trigger parenting fix script (by xen)										\\
//==============================================================================\\

//==============================================================================\\
//	WHAT IT DOES:					 								 			\\
//																 				\\
//	This script clears the trigger's parent and instead teleports the trigger	\\
//	to it every INTERVAL seconds (default is 0 which is every tick).			\\
//																 				\\
//	This is mainly useful to fix a CS:GO bug where parented triggers can fire 	\\
//	multiple times from a single touch.											\\
//==============================================================================\\
//	HOW TO USE IT:					 								 			\\
//																 				\\
// - Make sure your trigger's origin is exactly at its parent's origin.			\\
// - Add this file to its entity scripts and "Tick" as the think function.		\\
//==============================================================================\\

const INTERVAL = 0;	// Raise this if any performance issues arise

g_hParent <- null;
g_bActive <- false;

function CheckParent()
{
	local hParent = self.GetMoveParent();
	
	if (hParent == null)
		return;
	
    EntFireByHandle(self, "ClearParent", "", 0, null, null);
	
	g_bActive = true;
	g_hParent = hParent;
}

function Tick()
{
	CheckParent();
	
    if (!g_bActive)
		return;

    if (!g_hParent.IsValid())
    {
		self.Destroy(); // Parent just got killed, so this should be killed too
        return;
    }
	
	self.SetOrigin(g_hParent.GetOrigin());
    local angles = g_hParent.GetAngles();
    self.SetAngles(angles.x, angles.y, angles.z);
	
	return INTERVAL;
}